import Foundation

class User
{
    var name: String!
    var uid: String!

    init (inpName : String, inpUid: String)
    {
        self.name = inpName
        self.uid = inpUid
    }
    
    // a failable init
    convenience init? ( inpDict : Dictionary <String, Any> )
    {
        guard
            let readName = inpDict["nameKey"] as? String,
            let readUid = inpDict["uidKey"] as? String
            else
        {
            return nil
        }
        
        self.init(inpName: readName, inpUid: readUid)
    }
}

// this came from backend
var userDict = ["nameKey" : "Amir", "uidKey" : "ksdrvlsblbslkbjs"]

var myUser = User (inpDict: userDict)
